﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Demo.DataModel;

namespace Demo.WinFormApp
{
    public partial class CustomerList : UserControl
    {
        public CustomerList()
        {
            InitializeComponent();
        }

        private void CustomerList_Load(object sender, EventArgs e)
        {
            customerPresentationModelBindingSource.DataSource = CustomerPresentationModel.Instance;
            customerBindingSource.DataSource = CustomerPresentationModel.Instance.Items;

            CustomerPresentationModel.Instance.PropertyChanged += delegate(object s, PropertyChangedEventArgs ev)
            {
                if (ev.PropertyName == "Items")
                    customerBindingSource.DataSource = CustomerPresentationModel.Instance.Items;
            };
        }

        private void txtSearch_TextChanged(object sender, EventArgs e)
        {
            CustomerPresentationModel.Instance.SearchText = txtSearch.Text;
        }

        private void customerBindingSource_CurrentItemChanged(object sender, EventArgs e)
        {
            CustomerPresentationModel.Instance.SelectedItem = customerBindingSource.Current as Customer;
        }
  
    }
}
